7                     8  ?      7                          >    >    >    >    >   >) X  >    >    >    > 
  > 
  >    > X  > x  >    ?e    ?   ? *  ?    >                                                                        Front Ending Deluxe Music 
	Beginning with version 2.0 of AmigaDOS, a new feature known as public screens became available. This feature allows any program to declare its custom screen as a public screen on which other programs can create windows. Many of the newer programs for the Amiga, including Deluxe Music 2.0 (Figure 1), register their screens as public with the operating system, thus allowing other programs to open windows on them. Of course, the ability to open a window on another program's screen is not very useful unless there is some way for the programs to communicate with each other. This is where ARexx comes in. It is the standard way for programs to communicate on the Amiga. In this article I will discuss a CanDo 2.51 program I wrote named RandomNotes. It makes use of CanDo's ability to open windows on public screens and its ARexx communications capabilities. The RandomNotes program is shown in Listing 1. 

 RandomNotes Features 
	RandomNotes opens a window on Deluxe Music's screen (Figure 2) and then sends ARexx commands to Deluxe Music to create a random tune based on user input. This input includes selecting a key signature, a time signature, the number of measures in the tune, and a couple of parameters that confine the randomness of the notes. When the Generate button is pressed, the tune is created. The tune can be played by pressing the Play button and stopped by pressing the Stop button. The key signature has an initial value of C-MAJOR and is displayed in the rollo button in the upper-left corner of the RandomNotes window. The key can be changed by pressing the rollo button. Each time it is pressed, the key changes. There are 30 possible key signatures recognized by Deluxe Music. 

 
	The time signature has a default value of 4/4 which means that there are four beats per measure (top number) with a quarter note receiving one beat (bottom number). If this were changed to 3/8, then there would be three beats to a measure with an eighth note receiving one beat. The beats per measure and note to receive a beat can be changed by pressing the appropriate arrow buttons to the right of the time signature display. The upper number can vary from 1 to 16 in steps of 1 while the lower number can vary from 1 to 64 in multiples of 2 (e.g. 1, 2, 4, 8, ...). 

 
	The number of measures has a default value of four but can be changed by clicking the integer input field and typing a new value. This value controls the total number of measures in the random tune. 

 
	The two parameters that confine the randomness of the notes in the tune are the maximum note duration variation and the maximum note variation. The former controls the amount of variation in note duration from the base beat value in the time signature (the bottom number) and has a default value of one. The latter controls the maximum variation in the note pitch from one note to the next and has a default value of two. Each of these values can be changed by typing a new number into the appropriate field. 

 
	When the Generate button is pressed, RandomNotes sends Deluxe Music the appropriate ARexx commands to clear the current tune, set the key signature and the time signature, and insert the randomly generated notes. Once the tune is generated, it can be played by pressing the Play button and stopped by pressing the Stop button. 

 The DMCard Card 
	The RandomNotes deck consists of only one card named DMCard. As shown in the card's Window definition section (Listing 1), it opens on the DeluxeMusic public screen (Figure 2). The public screen name can be selected from the Window Editor requester (Figure 3). When the button to the right of the Public Screen check box is pressed, a list of available public screens will be presented. Of course, Deluxe Music must be loaded for its screen to appear in the list. 

 
	The DMCard card has a BeforeAttachment and an AfterAttachment script. The BeforeAttachment script first attempts to speak to the DMUSIC ARexx port. If an error occurs, then Deluxe Music is not currently running. The script then attempts to execute Deluxe Music and continues to look for the DMUSIC ARexx port. If it is not found, RandomNotes prints a message and exits. If the port is found, the script pauses for five seconds to allow time for Deluxe Music's screen to be set up and registered as public with the operating system. If RandomNotes attaches its card before Deluxe Music's screen is set up, it will open on the Workbench screen instead. The five second delay may need to be increased on slower systems. After the ARexx connection is established, a Deluxe Music ARexx command, GETATTR, is sent to Deluxe Music. This command tells Deluxe Music that some information is needed, in this case the width of the document window (the one with the musical score). Deluxe Music then passes the requested information back to RandomNotes. CanDo stores return values from an ARexx command in the system variable, MessageReturned. This value is used as part of another ARexx command, SIZEWINDOW. Here, Deluxe Music is directed to re-size the height of its current window (the document or score window) to 280. The width remains the same since the current width obtained from the GETATTR command is passed back in the SIZEWINDOW command. After the window is re-sized, there will be space at the bottom of the screen for the RandomNotes window. The difference can be seen by comparing Figures 1 and 2. Finally, the 30 elements of the KeyText array are defined. The text used for the array elements is the same as that needed in the Deluxe Music ARexx commands as you will see later. 

 
	The AfterAttachment script writes all the necessary labels on the card. It then loads a brush named MusicStaff.br into a buffer named ClippedBrush. This brush is used by the routine ShowTime to display the time signature. Next, the initial time signature values are assigned and displayed. Finally, the initial key signature index is set and its text is displayed. 

 The Key Signature Button 
	This button is an area button with a rollo border, which indicates that a press of the button will change the selection text within it. The initial text on the button is C-MAJOR, which is the value of KeyText[1]. Each time the button is pressed, its OnRelease script executes. This script simply increments the value of KeyTextIndex by one and executes the global routine, ShowKey. A modulo operator is used to ensure that the value of KeyTextIndex never exceeds 30, which is the number of elements in the array. The ShowKey routine erases the text in the rollo button and replaces it with the text in the current element of the KeyText array. 

 The Time Signature Buttons 
	The time signature consists of two numbers: the beats per measure (top number) and the note to receive a beat (bottom number). There is a pair of left and right arrow buttons to the right of each number for adjusting each independently. The buttons for adjusting the number of beats per measure are named BeatsLeft and BeatsRight. The buttons for adjusting the note to receive a beat are named NoteBeatLeft and NoteBeatRight. Each button has an OnClick event script. The algorithm in each of these scripts will be executed when the user clicks on the respective buttons and will continue to execute until the mouse button is released. The BeatsLeft and BeatsRight buttons simply decrement and increment by one the current value of Beats, which is the top number in the time signature, ensuring that its value never drops below one or exceeds 16. The NoteBeatLeft and NoteBeatRight buttons simply decrement and increment by multiples of two the current value of NoteBeat, which is the bottom number in the time signature, ensuring that its value never drops below one or exceeds 64. 
	The script for each of the four time signature buttons executes a global routine named ShowTime each time the Beats or NoteBeat variable is changed. This routine re-displays the ClippedBrush brush containing the small musical staff, overwriting the current display. Next, the Beats and NoteBeat values are printed on top of the brush. A simple algorithm is used for the printing of each number so that it will be centered in the musical staff brush regardless of whether the number has one or two digits. Each of the scripts for the four time signature buttons also has a short delay built in so the numbers do not change faster than the user's mouse button finger can respond. 

 The Generate, Play, and Stop Buttons 
	The Generate button's OnRelease script is a hotbed of activity. It sends many messages to Deluxe Music and has a lot of mathematical formulas that generate the random musical score. Let's follow it through in detail. 
	First, five commands are send to Deluxe Music: CLEAR FORCE, LOCKDISPLAY, LOCKGUI, SETKEYSIGNATURE, and SETTIMESIGNATURE. The CLEAR command tells Deluxe Music to clear the current document; the FORCE option specifies that the user should not be prompted for a verification of this action. LOCKDISPLAY prevents the document window from updating each time a new note is added to the score. LOCKGUI prevents the user from directly controlling the Deluxe Music interface. As you probably guessed, SETKEYSIGNATURE and SETTIMESIGNATURE are used to set the key signature and the time signature of the current score. 
	Next, the total number of Beats in the score, TotalBeats, is calculated by multiplying the number of beats in a measure times the number of measures in the score. Also, the user specified limitations on the variation in a note's pitch, MNV, and a note's duration, MNDV, are extracted from the appropriate integer fields. 
	In preparation for the note insertion loop, three variables are initialized. NumBeats, which will keep up with the total number of beats in the score, is set to zero. NumBeatsMeasure, which will keep up with the total number of beats in each measure, is set to zero. Finally, Line, which will keep up with the line on the musical staff where the next note will be inserted, is set to zero. A line number of zero is the middle line of the staff. Positive line numbers are above this line and negative numbers are below this line. 
	Now it is time to enter the note insertion loop. As long as the actual number of beats in the score is less than the total number of beats to be added to the score, this loop will execute. 
	The first task of the loop is to determine the line on which the next note will appear. This is accomplished by selecting a random integer between -MNV and +MNV and adding this value to Line. Remember that the user specified the value of MNV and therefore has control over how many lines can separate consecutive notes in the score. A similar method is used for determining the duration of the next note. A random integer between -MNDV and +MNDV is selected. Then the value of NoteBeat (set in the time signature) is multiplied by two raised to the power of the random integer. This will scale the duration up or down by some multiple of two. Once this is calculated, the Min and Max functions are used to make sure the new note duration is not less than one (a whole note) or greater than 64 (a sixty- fourth note), the minimum and maximum allowable by Deluxe Music. Next, the current note duration is adjusted, if necessary, to prevent the number of beats in the current measure from exceeding the value of Beats, which was set in the time signature. 
	The next task of the loop is to insert the note into the Deluxe Music score. An INSERTITEM NOTE ARexx command is issued along with the DURATION and LINE information. Next, the command NEXT NOTE tells Deluxe Music to prepare to receive the next note in the score. 
	After inserting the note, the current numbers of beats in the measure and in the score are updated. If the current measure has been filled with the appropriate number of beats, then Deluxe Music is sent the NEXT MEASURE command so that it will prepare a new measure for the upcoming notes. The number of beats in the current measure, NumBeatsMeasure, is then reset to zero. 
	This ends the loop. As stated, it will continue to execute until the total number of beats for the score has been met. When the loop is exited, five more Arexx commands are sent to Deluxe Music. UNLOCKGUI allows the user to directly interact with the Deluxe Music interface. UNLOCKDISPLAY frees Deluxe Music to display the score that has been created by RandomNotes. WINDOW DOCUMENT ACTIVATE activates the score window. UPDATEDISPLAY causes the score to be displayed. Finally, POSITION SOF positions Deluxe Music's cursor at the start of the score. 
	Once the score has been generated, it is time to listen to it. By pressing the Play button in the RandomNotes window, its OnRelease script will execute. This script sends two commands to Deluxe Music: WINDOW DOCUMENT ACTIVATE and PLAY. The former makes sure that the score window is active; the latter directs Deluxe Music to play the score. Once the score finishes playing, it will repeat. To stop the score, press the Stop button. A STOP command will be sent to Deluxe Music. 

 Enhancing the Scores 
	Since RandomNotes only produces a user constrained random score, most of the scores will not sound good. However, since they are so simple to create, many scores can be created in a short amount of time. Occasionally, one will sound fairly good. At this point, the user can interact directly with the Deluxe Music interface to modify the fairly good score to make it a very good or even excellent score, depending on the abilities of the user. In other words, RandomNotes should be viewed as an idea generator. It produces a score that helps plant a tune into the mind of the musician. The musician can then enhance the score to fit the idea. 
	If you are familiar with music theory, you might want to modify the algorithms in RandomNotes and create a program named MozartNotes, or BachNotes, or even MadonnaNotes. In other words, the program could take user defined parameters and create an original score that is reminiscent of the tunes written by or performed by a particular musical artist. If anyone creates such a program, I would be very interested in seeing it. Write to me care of this magazine.  
CB71283C96CACED1D0C98C3C34A6DCD9D9DFE0E0DEDB
DCDBDCE0DFDFDFE0DDDCDBE1E1E1E0DBD5CBC6BEB1A29C826C50302527324C58636B79B4D9DBDD
DBDCDCD6D6D4D3C45C3379C8C6C7CDB163384595D1CFD3D6DDDBD7DFDDDCDDDEDCDEDBD9E0DDDD
DADEDADAD3D0C6BAB0A08A6F4D33282937424E585B5E759FB6B4BDB9B9
BFC2BEC1BFBFBDC1C2C4C3C1BFBFB6B2ABA8A6A19A8D80706351462E2926334E5D74B0D7D4D7E3
DBCED6BE57     8                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
  
  
  
  
  
            1               o  p        /  k  "  "  ";  #  %x  &  (  )  -  .  0-  2T  44  45  4L  6  8                                                                                                                                                 !     !     !     
!     !     !     !     !     	!     !     !     !  1        
               7       	      %5  /  7        t                      8      8       
       ! "                    3/30313233349394959697    H H    (FG(    H H    (    d       '                     @                         =/  R    @      H 
-:LaserWriter 
     (  (      6n  6z     6n                                                              